require "prefabutil"

local assets =
{
    Asset("ANIM", "anim/astlight.zip"),
	Asset("ATLAS", "images/inventoryimages/millbox.xml")
}

local prefabs =
{
    "collapse_small",
	"flint",
	"poop",
}

local function onhammered(inst, worker)
    if inst.components.burnable ~= nil and inst.components.burnable:IsBurning() then
        inst.components.burnable:Extinguish()
    end
    local x, y, z = inst.Transform:GetWorldPosition()
    SpawnPrefab("goldnugget").Transform:SetPosition(x, y, z)
	SpawnPrefab("boards").Transform:SetPosition(x, y, z)
    
    inst:Remove()
end

local function onhit(inst, worker)
	inst.AnimState:PlayAnimation("hit")
	inst.AnimState:PushAnimation("idle", true)
end


local function onbuilt(inst)
    inst.SoundEmitter:PlaySound("dontstarve/common/sign_craft")
end
--分解系统
local function OnGetItemFromPlayer(inst, giver, item)
    if item.prefab == "condense_cutgrass" 
	then 
	for k = 1, 40 do
giver.components.inventory:GiveItem( SpawnPrefab("cutgrass")) end
    end
	--
    if item.prefab == "condense_goldnugget" 
	then 
	for k = 1, 20 do
giver.components.inventory:GiveItem( SpawnPrefab("goldnugget")) end
    end
	--
	    if item.prefab == "condense_rocks" 
	then 
	for k = 1, 40 do
giver.components.inventory:GiveItem( SpawnPrefab("rocks")) end
    end
	--
	    if item.prefab == "condense_twigs" 
	then 
	for k = 1, 40 do
giver.components.inventory:GiveItem( SpawnPrefab("twigs")) end
    end
	    if item.prefab == "condense_flint" 
	then 
	for k = 1, 40 do
giver.components.inventory:GiveItem( SpawnPrefab("flint")) end
    end
	    if item.prefab == "condense_nitre" 
	then 
	for k = 1, 40 do
giver.components.inventory:GiveItem( SpawnPrefab("nitre")) end
    end
	    if item.prefab == "wood" 
	then 
	for k = 1, 20 do
giver.components.inventory:GiveItem( SpawnPrefab("log")) end

    if item.prefab == "magicpower_mk2" 
	then 
	for k = 1, 40 do
giver.components.inventory:GiveItem( SpawnPrefab("magicpower")) end
    end
    end
end

local function OnRefuseItem(inst, giver, item)
    inst.SoundEmitter:PlaySound("dontstarve/pig/PigKingReject")
    inst.AnimState:PlayAnimation("hit")
end
local function complete_doonact(inst)
    if inst._activecount > 1 then
        inst._activecount = inst._activecount - 1
    else
        inst._activecount = 0
        --inst.SoundEmitter:KillSound("sound")
    end

    --inst.SoundEmitter:PlaySound("dontstarve/common/researchmachine_lvl3_ding")
end
local function onactivate(inst)
    inst._activecount = inst._activecount + 1
    --if not inst.SoundEmitter:PlayingSound("sound") then
    --    inst.SoundEmitter:PlaySound("dontstarve/common/ancienttable_craft", "sound")
    --end

    inst:DoTaskInTime(1.5, complete_doonact)
end

local function fn()
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
    MakeObstaclePhysics(inst, .2)
	inst.entity:AddDynamicShadow()
	inst.DynamicShadow:SetSize( 2,2 )
    inst.AnimState:SetBank("astlight")
    inst.AnimState:SetBuild("astlight")
    inst.AnimState:PlayAnimation("idle",true)
    MakeSnowCoveredPristine(inst)
    inst:AddTag("structure")
    inst:AddTag("sign")
    inst.entity:SetPristine()
    if not TheWorld.ismastersim then
        return inst
    end
	inst._activecount = 0
	--分解
     inst:AddComponent("trader")
	 inst.components.trader:SetAcceptTest(function(inst,item)
	 if item.prefab == "condense_rocks" or item.prefab == "condense_goldnugget" or item.prefab == "condense_flint" or item.prefab == "condense_cutgrass"  or item.prefab == "condense_twigs"  or item.prefab == "condense_nitre" or item.prefab == "wood" or item.prefab == "magicpower_mk2"  
	 then
	 return true
	 end
	 return false
	 end)
	 inst.components.trader.onaccept = OnGetItemFromPlayer
	
	inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(5)
    inst.components.workable:SetOnFinishCallback(onhammered)
    inst.components.workable:SetOnWorkCallback(onhit)
    inst:AddComponent("inspectable")
	inst:AddComponent("prototyper")
    inst.components.prototyper.onactivate = onactivate
	inst.components.prototyper.trees = TUNING.PROTOTYPER_TREES.TOU_ASTITEM_TWO
    inst:AddComponent("lootdropper")
	   inst:ListenForEvent("onbuilt", onbuilt)
	   local light = inst.entity:AddLight()
	light:SetColour(51/255, 255/255, 255/255)
	light:SetIntensity(0.8)
	light:SetRadius(2.2)
	light:SetFalloff(.33)
	inst.Light:Enable(true)
	   MakeHauntableWork(inst)
	   inst.Transform:SetScale(.7, .7, .7)
    return inst
end
return Prefab("astlight", fn, assets, prefabs),
    MakePlacer("astlight_placer", "astlight", "astlight", "idle")
